/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.ArcRenderer;
import acm.graphics.GCanvas;
import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.graphics.GScalable;
import acm.util.Platform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GOval
extends GObject
implements GFillable,
GResizable,
GScalable {
    private boolean useArcs = this.checkForArcRendering();
    private double frameWidth;
    private double frameHeight;
    private boolean isFilled;
    private Color fillColor;
    private ArcRenderer renderer;

    public GOval(double d, double d2) {
        this(0.0, 0.0, d, d2);
    }

    public GOval(double d, double d2, double d3, double d4) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
        this.renderer = new ArcRenderer(this);
    }

    public boolean contains(double d, double d2) {
        double d3;
        double d4 = this.frameWidth / 2.0;
        double d5 = this.frameHeight / 2.0;
        if (d4 == 0.0 || d5 == 0.0) {
            return false;
        }
        double d6 = d - (this.getX() + d4);
        return d6 * d6 / (d4 * d4) + (d3 = d2 - (this.getY() + d5)) * d3 / (d5 * d5) <= 1.0;
    }

    public void paint(Graphics graphics) {
        Component component = this.getComponent();
        if (component instanceof GCanvas && !((GCanvas)component).getNativeArcFlag()) {
            this.renderer.draw(graphics);
        } else {
            Rectangle rectangle = this.getAWTBounds();
            if (this.useArcs) {
                if (this.isFilled()) {
                    graphics.setColor(this.getFillColor());
                    graphics.fillArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 360);
                    graphics.setColor(this.getColor());
                }
                graphics.drawArc(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 360);
            } else {
                if (this.isFilled()) {
                    graphics.setColor(this.getFillColor());
                    graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics.setColor(this.getColor());
                }
                graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public void setFilled(boolean bl) {
        this.isFilled = bl;
        this.repaint();
    }

    public boolean isFilled() {
        return this.isFilled;
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
        this.repaint();
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public void setSize(double d, double d2) {
        this.frameWidth = d;
        this.frameHeight = d2;
        this.repaint();
    }

    public final void setSize(GDimension gDimension) {
        this.setSize(gDimension.getWidth(), gDimension.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.frameWidth, this.frameHeight);
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.frameWidth = d3;
        this.frameHeight = d4;
        this.setLocation(d, d2);
    }

    public final void setBounds(GRectangle gRectangle) {
        this.setBounds(gRectangle.getX(), gRectangle.getY(), gRectangle.getWidth(), gRectangle.getHeight());
    }

    public GRectangle getBounds() {
        return new GRectangle(this.getX(), this.getY(), this.frameWidth + 1.0, this.frameHeight + 1.0);
    }

    public double getWidth() {
        return this.frameWidth;
    }

    public double getHeight() {
        return this.frameHeight;
    }

    public void scale(double d, double d2) {
        this.frameWidth *= d;
        this.frameHeight *= d2;
        this.repaint();
    }

    public final void scale(double d) {
        this.scale(d, d);
    }

    protected Rectangle getAWTBounds() {
        return new Rectangle(GMath.round(this.getX()), GMath.round(this.getY()), GMath.round(this.frameWidth), GMath.round(this.frameHeight));
    }

    private boolean checkForArcRendering() {
        return Platform.isMac();
    }
}

